package com.purplefrogg;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PFont;

public class Main extends PApplet{

    static int[][] board = new int[8][8];
    int rowPicked;
    int columnPicked;
    int newRowPicked;
    int newColumnPicked;
    boolean whiteTurn;
    int[] optionsX = new int[100];
    int[] optionsY = new int[100];
    int pieceThatIsMoving;
    int originalPiece;
    int optionsFilled;
    boolean rookOneMoveWhite;
    boolean rookTwoMoveWhite;
    boolean rookOneMoveBlack;
    boolean rookTwoMoveBlack;
    boolean kingMoveWhite;
    boolean kingMoveBlack;
    boolean hovering;
    static boolean allowEnPassant;
    static boolean enPassantLeft;
    static boolean enPassantRight;
    boolean thisWasEnPassant;
    boolean kingDanger;
    boolean inCheck;
    boolean isInsufficient;
    boolean captureWasMade;
    boolean whitePromote;
    boolean blackPromote;
    int mateType;
    int repetitionType;
    int pieceValuesWhite;
    int pieceValuesBlack;
    int kingX;
    int kingY;

    SmallSaveBoard SSB = new SmallSaveBoard();

    PImage whitePawn;
    PImage whiteBishop;
    PImage whiteKnight;
    PImage whiteRook;
    PImage whiteQueen;
    PImage whiteKing;

    PImage blackPawn;
    PImage blackBishop;
    PImage blackKnight;
    PImage blackRook;
    PImage blackQueen;
    PImage blackKing;

    enum GameState {
        RUNNING, WHITEWIN, BLACKWIN, DRAW
    }
    static GameState currentState;

    enum PossibleEndings {
        CHECKMATE, STALEMATE, INSUFFICIENT, THREEMOVEREPETITION, FIFTYMOVERULE
    }
    static PossibleEndings howEnd;

    PFont winBigFont;
    PFont winFont;
    int winFillColor;

    public static void main(String[] args) {
        PApplet.main("com.purplefrogg.Main");
    }

    public void settings() {
        size(800, 800);
    }

    public void setup() {
        surface.setTitle("Chess");
        whiteTurn = true;
        optionsFilled = 0;
        rookOneMoveWhite = false;
        rookTwoMoveWhite = false;
        rookOneMoveBlack = false;
        rookTwoMoveBlack = false;
        kingMoveWhite = false;
        kingMoveBlack = false;
        allowEnPassant = false;
        enPassantLeft = false;
        enPassantRight = false;
        thisWasEnPassant = false;
        kingDanger = false;
        inCheck = false;
        isInsufficient = false;
        pieceValuesWhite = 0;
        pieceValuesBlack = 0;
        strokeWeight(0);
        currentState = GameState.RUNNING;
        setStartingPosition();
        drawCurrentPosition();
        clearOptions();
    }

    public void draw() {
        switch (currentState) {
            case RUNNING -> {
                drawCurrentPosition();
                showMovementOptions();
                showKingDanger();
                hover();
                showPromote();
            }
            case BLACKWIN, WHITEWIN, DRAW -> drawEndScreen();
        }
    }

    public void mousePressed() {
        switch (currentState) {
            case RUNNING:
                if (mouseX >= 0 && mouseX <= 800 && mouseY >= 0 && mouseY <= 800) {
                    if (whitePromote || blackPromote) {
                        promote(mouseX, mouseY);
                    } else {
                        if (board[mouseX / 100][mouseY / 100] > 0 && whiteTurn) {
                            clearOptions();
                            rowPicked = mouseX / 100;
                            columnPicked = mouseY / 100;
                            hovering = true;
                            findLegalMoves(rowPicked, columnPicked);
                        } else if (board[mouseX / 100][mouseY / 100] < 0 && !whiteTurn) {
                            clearOptions();
                            rowPicked = mouseX / 100;
                            columnPicked = mouseY / 100;
                            hovering = true;
                            findLegalMoves(rowPicked, columnPicked);
                        } else if (board[mouseX / 100][mouseY / 100] <= 0 && whiteTurn) {
                            newRowPicked = mouseX / 100;
                            newColumnPicked = mouseY / 100;
                            for (int i = 0; i <= 20; i++) {
                                if (newRowPicked == optionsX[i] && newColumnPicked == optionsY[i]) {
                                    movePiece(rowPicked, columnPicked, newRowPicked, newColumnPicked);
                                }
                            }
                        } else if (board[mouseX / 100][mouseY / 100] >= 0 && !whiteTurn) {
                            newRowPicked = mouseX / 100;
                            newColumnPicked = mouseY / 100;
                            for (int i = 0; i <= 20; i++) {
                                if (newRowPicked == optionsX[i] && newColumnPicked == optionsY[i]) {
                                    movePiece(rowPicked, columnPicked, newRowPicked, newColumnPicked);
                                }
                            }
                        }
                    }
                }
                break;
            case DRAW:
            case BLACKWIN:
            case WHITEWIN:

                if (mouseX > 300 && mouseX < 500 && mouseY > 520 && mouseY < 610) {
                    setup();
                }
                break;
        }
    }

    public void mouseReleased() {
        if (currentState == GameState.RUNNING) {
            hovering = false;
            if (mouseX >= 0 && mouseX <= 800 && mouseY >= 0 && mouseY <= 800) {
                if (board[mouseX / 100][mouseY / 100] <= 0 && whiteTurn) {
                    newRowPicked = mouseX / 100;
                    newColumnPicked = mouseY / 100;
                    for (int i = 0; i <= 20; i++) {
                        if (newRowPicked == optionsX[i] && newColumnPicked == optionsY[i]) {
                            movePiece(rowPicked, columnPicked, newRowPicked, newColumnPicked);
                        }
                    }
                } else if (board[mouseX / 100][mouseY / 100] >= 0 && !whiteTurn) {
                    newRowPicked = mouseX / 100;
                    newColumnPicked = mouseY / 100;
                    for (int i = 0; i <= 20; i++) {
                        if (newRowPicked == optionsX[i] && newColumnPicked == optionsY[i]) {
                            movePiece(rowPicked, columnPicked, newRowPicked, newColumnPicked);
                        }
                    }
                }
            }
        }
    }

    public void hover() {
        if (hovering) {
            int piece = board [rowPicked][columnPicked];
            if ((rowPicked % 2 == 1 && columnPicked % 2 == 1) || (rowPicked % 2 == 0 && columnPicked % 2 == 0)) {
                fill(200, 200, 200);
            } else {
                fill(100, 100, 100);
            }
            rect(rowPicked*100, columnPicked*100, 100, 100);

            imageMode(CENTER);
            if (piece == 1) {
                image(whitePawn, mouseX, mouseY);
            } else if (piece == 2 || piece == 3 || piece == 8) {
                image(whiteRook, mouseX, mouseY);
            } else if (piece == 4) {
                image(whiteBishop, mouseX, mouseY);
            } else if (piece == 5) {
                image(whiteKnight, mouseX, mouseY);
            } else if (piece == 6) {
                image(whiteQueen, mouseX, mouseY);
            } else if (piece == 7) {
                image(whiteKing, mouseX, mouseY);
            } else if (piece == -1) {
                image(blackPawn, mouseX, mouseY);
            } else if (piece == -2 || piece == -3 || piece == -8) {
                image(blackRook, mouseX, mouseY);
            } else if (piece == -4) {
                image(blackBishop, mouseX, mouseY);
            } else if (piece == -5) {
                image(blackKnight, mouseX, mouseY);
            } else if (piece == -6) {
                image(blackQueen, mouseX, mouseY);
            } else if (piece == -7) {
                image(blackKing, mouseX, mouseY);
            }
        }
    }

    public void drawBoard(){
        for (int i = 0; i <= 7; i++){
            for (int j = 0; j <= 7; j++){
                int xBoardPos = i*100;
                int yBoardPos = j*100;
                if (j % 2 == 0 && i % 2 == 0) {
                    fill(200, 200, 200);
                } else if (j % 2 != 0 && i % 2 == 0) {
                    fill(100, 100, 100);
                } else if (j % 2 == 0) {
                    fill(100, 100, 100);
                } else {
                    fill(200, 200, 200);
                }
                square(xBoardPos, yBoardPos, 100);
            }
        }
    }

    public void setStartingPosition() {
        //Set all squares to 0 value
        for (int i = 0; i <= 7; i++) {
            for (int j = 0; j <= 7; j++) {
                board[i][j] = 0;
            }
        }

        //Black Pieces
        board[0][0] = -2; //Rook 1
        board[1][0] = -5; //Knight
        board[2][0] = -4; //Bishop
        board[3][0] = -6; //Queen
        board[4][0] = -7; //King
        board[5][0] = -4; //Bishop
        board[6][0] = -5; //Knight
        board[7][0] = -3; //Rook 2
        for (int i = 0; i <= 7; i++) {
            board[i][1] = -1;
        }

        //White Pieces
        board[0][7] = 2; //Rook 1
        board[1][7] = 5; //Knight
        board[2][7] = 4; //Bishop
        board[3][7] = 6; //Queen
        board[4][7] = 7; //King
        board[5][7] = 4; //Bishop
        board[6][7] = 5; //Knight
        board[7][7] = 3; //Rook 2
        for (int i = 0; i <= 7; i++) {
            board[i][6] = 1;
        }

        whitePawn = loadImage("White Pawn.png");
        whiteBishop = loadImage("White Bishop.png");
        whiteKnight = loadImage("White Knight.png");
        whiteRook = loadImage("White Rook.png");
        whiteQueen = loadImage("White Queen.png");
        whiteKing = loadImage("White King.png");

        blackPawn = loadImage("Black Pawn.png");
        blackBishop = loadImage("Black Bishop.png");
        blackKnight = loadImage("Black Knight.png");
        blackRook = loadImage("Black Rook.png");
        blackQueen = loadImage("Black Queen.png");
        blackKing = loadImage("Black King.png");

        surface.setIcon(whitePawn);
        SSB.addStartingPosition();
    }

    public void drawEndScreen() {
        fill(213, 176, 124);
        rect(190, 90, 420, 620);

        textAlign(CENTER);
        winBigFont = createFont("Arial", 50);
        winFont = createFont("Arial", 25);

        textFont(winBigFont);
        switch (currentState) {
            case WHITEWIN -> {
                winFillColor = 255;
                fill(winFillColor);
                text("White Wins", 400, 180);
            }
            case BLACKWIN -> {
                winFillColor = 0;
                fill(winFillColor);
                text("Black Wins", 400, 180);
            }
            case DRAW -> {
                winFillColor = 128;
                fill(winFillColor);
                text("Draw", 400, 180);
            }
        }

        textFont(winFont);
        switch (howEnd) {
            case CHECKMATE -> {
                fill(winFillColor);
                text("By Checkmate", 400, 220);
            }
            case STALEMATE -> {
                fill(winFillColor);
                text("By Stalemate", 400, 220);
            }
            case INSUFFICIENT -> {
                fill(winFillColor);
                text("Insufficient Material", 400, 220);
            }
            case THREEMOVEREPETITION -> {
                fill(winFillColor);
                text("Three Move Repetition", 400, 220);
            }
            case FIFTYMOVERULE -> {
                fill(winFillColor);
                text("Fifty Move Rule", 400, 220);
            }
        }

        fill(79, 89, 76);
        rect(300, 520, 200, 90);
        textFont(winFont);
        fill(255, 255, 255);
        text("Play Again", 400, 570);
    }

    public void findLegalMoves(int rowPicked, int columnPicked) {
        PutKingInDanger PKID = new PutKingInDanger();
        int piece = board [rowPicked][columnPicked];

        //White Pawn
        if (piece==1 && whiteTurn) {
            if (columnPicked != 0) {
                if (board[rowPicked][columnPicked-1] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                } if (board[rowPicked][columnPicked-1] == 0 && columnPicked == 6 && board[rowPicked][columnPicked - 2] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - 2;
                    optionsFilled++;
                }
            } if (rowPicked != 0 && columnPicked != 0) {
                if (board[rowPicked-1][columnPicked-1] < 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
                if (allowEnPassant && columnPicked == 3 && board[rowPicked-1][columnPicked] == -1 && enPassantLeft) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                    thisWasEnPassant = true;
                }
            } if (rowPicked != 7 && columnPicked != 0) {
                if (board[rowPicked+1][columnPicked-1] < 0) {
                    optionsX[optionsFilled] = rowPicked+1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
                if (allowEnPassant && columnPicked == 3 && board[rowPicked+1][columnPicked] == -1 && enPassantRight) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                    thisWasEnPassant = true;
                }
            }
        }
        //Black Pawn
        else if (piece==-1 && !whiteTurn) {
            if (columnPicked != 7) {
                if (board[rowPicked][columnPicked + 1] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                } if (board[rowPicked][columnPicked + 1] == 0 && columnPicked == 1 && board[rowPicked][columnPicked + 2] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + 2;
                    optionsFilled++;
                }
            } if (rowPicked != 0 && columnPicked != 7) {
                if (board[rowPicked - 1][columnPicked + 1] > 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
                if (allowEnPassant && columnPicked == 4 && board[rowPicked-1][columnPicked] == 1 && enPassantLeft) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                    thisWasEnPassant = true;
                }
            } if (rowPicked != 7 && columnPicked != 7) {
                if (board[rowPicked + 1][columnPicked + 1] > 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
                if (allowEnPassant && columnPicked == 4 && board[rowPicked+1][columnPicked] == 1 && enPassantRight) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                    thisWasEnPassant = true;
                }
            }
        }
        //White Bishop
        else if (piece == 4 && whiteTurn) {
            for (int i=1; i<=rowPicked && i<=columnPicked; i++) {
                if (board[rowPicked-i][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked-i] < 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked-i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked && i<=columnPicked; i++) {
                if (board[rowPicked+i][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked-i] < 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked-i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked && i<=7-columnPicked; i++) {
                if (board[rowPicked-i][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked+i] < 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked+i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked && i<=7-columnPicked; i++) {
                if (board[rowPicked+i][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked+i] < 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked+i] > 0) {
                    i = 100;
                }
            }
        }
        //Black Bishop
        else if (piece == -4 && !whiteTurn) {
            for (int i=1; i<=rowPicked && i<=columnPicked; i++) {
                if (board[rowPicked-i][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked-i] > 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked-i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked && i<=columnPicked; i++) {
                if (board[rowPicked+i][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked-i] > 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked-i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked && i<=7-columnPicked; i++) {
                if (board[rowPicked-i][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked+i] > 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked+i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked && i<=7-columnPicked; i++) {
                if (board[rowPicked+i][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked+i] > 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked+i] < 0) {
                    i = 100;
                }
            }
        }
        //White Knight
        else if (piece == 5 && whiteTurn) {
            if (rowPicked > 0 && columnPicked > 1) {
                if (board[rowPicked-1][columnPicked-2] <= 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked - 2;
                    optionsFilled++;
                }
            } if (rowPicked < 7 && columnPicked > 1) {
                if (board[rowPicked+1][columnPicked-2] <= 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked - 2;
                    optionsFilled++;
                }
            } if (rowPicked > 0 && columnPicked < 6) {
                if (board[rowPicked-1][columnPicked+2] <= 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked + 2;
                    optionsFilled++;
                }
            } if (rowPicked < 7 && columnPicked < 6) {
                if (board[rowPicked+1][columnPicked+2] <= 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked + 2;
                    optionsFilled++;
                }
            } if (rowPicked > 1 && columnPicked > 0) {
                if (board[rowPicked-2][columnPicked-1] <= 0) {
                    optionsX[optionsFilled] = rowPicked - 2;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            } if (rowPicked > 1 && columnPicked < 7) {
                if (board[rowPicked-2][columnPicked+1] <= 0) {
                    optionsX[optionsFilled] = rowPicked - 2;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            } if (rowPicked < 6 && columnPicked > 0) {
                if (board[rowPicked+2][columnPicked-1] <= 0) {
                    optionsX[optionsFilled] = rowPicked + 2;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            } if (rowPicked < 6 && columnPicked < 7) {
                if (board[rowPicked+2][columnPicked+1] <= 0) {
                    optionsX[optionsFilled] = rowPicked + 2;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            }
        }
        //Black Knight
        else if (piece == -5 && !whiteTurn) {
            if (rowPicked > 0 && columnPicked > 1) {
                if (board[rowPicked-1][columnPicked-2] >= 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked - 2;
                    optionsFilled++;
                }
            } if (rowPicked < 7 && columnPicked > 1) {
                if (board[rowPicked+1][columnPicked-2] >= 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked - 2;
                    optionsFilled++;
                }
            } if (rowPicked > 0 && columnPicked < 6) {
                if (board[rowPicked-1][columnPicked+2] >= 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked + 2;
                    optionsFilled++;
                }
            } if (rowPicked < 7 && columnPicked < 6) {
                if (board[rowPicked+1][columnPicked+2] >= 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked + 2;
                    optionsFilled++;
                }
            } if (rowPicked > 1 && columnPicked > 0) {
                if (board[rowPicked-2][columnPicked-1] >= 0) {
                    optionsX[optionsFilled] = rowPicked - 2;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            } if (rowPicked > 1 && columnPicked < 7) {
                if (board[rowPicked-2][columnPicked+1] >= 0) {
                    optionsX[optionsFilled] = rowPicked - 2;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            } if (rowPicked < 6 && columnPicked > 0) {
                if (board[rowPicked+2][columnPicked-1] >= 0) {
                    optionsX[optionsFilled] = rowPicked + 2;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            } if (rowPicked < 6 && columnPicked < 7) {
                if (board[rowPicked+2][columnPicked+1] >= 0) {
                    optionsX[optionsFilled] = rowPicked + 2;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            }
        }
        //White Rook
        else if ((piece == 2 && whiteTurn) || (piece == 3 && whiteTurn) || (piece == 8 && whiteTurn)) {
            for (int i=1; i<=columnPicked; i++) {
                if (board[rowPicked][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked-i] < 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked][columnPicked-i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-columnPicked; i++) {
                if (board[rowPicked][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked+i] < 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked][columnPicked+i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked; i++) {
                if (board[rowPicked-i][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked] < 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked; i++) {
                if (board[rowPicked+i][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked] < 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked] > 0) {
                    i = 100;
                }
            }
        }
        //Black Rook
        else if ((piece == -2 && !whiteTurn) || (piece == -3 && !whiteTurn) || (piece == -8 && !whiteTurn)) {
            for (int i=1; i<=columnPicked; i++) {
                if (board[rowPicked][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked-i] > 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked][columnPicked-i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-columnPicked; i++) {
                if (board[rowPicked][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked+i] > 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked][columnPicked+i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked; i++) {
                if (board[rowPicked-i][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked] > 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked; i++) {
                if (board[rowPicked+i][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked] > 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked] < 0) {
                    i = 100;
                }
            }
        }
        //White Queen
        else if (piece == 6 && whiteTurn) {
            for (int i=1; i<=columnPicked; i++) {
                if (board[rowPicked][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked-i] < 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked][columnPicked-i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-columnPicked; i++) {
                if (board[rowPicked][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked+i] < 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked][columnPicked+i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked; i++) {
                if (board[rowPicked-i][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked] < 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked; i++) {
                if (board[rowPicked+i][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked] < 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked && i<=columnPicked; i++) {
                if (board[rowPicked-i][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked-i] < 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked-i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked && i<=columnPicked; i++) {
                if (board[rowPicked+i][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked-i] < 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked-i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked && i<=7-columnPicked; i++) {
                if (board[rowPicked-i][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked+i] < 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked+i] > 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked && i<=7-columnPicked; i++) {
                if (board[rowPicked+i][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked+i] < 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked+i] > 0) {
                    i = 100;
                }
            }
        }
        //Black Queen
        else if (piece == -6 && !whiteTurn) {
            for (int i=1; i<=columnPicked; i++) {
                if (board[rowPicked][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked-i] > 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked][columnPicked-i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-columnPicked; i++) {
                if (board[rowPicked][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked+i] > 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked][columnPicked+i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked; i++) {
                if (board[rowPicked-i][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked] > 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked; i++) {
                if (board[rowPicked+i][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked] > 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked && i<=columnPicked; i++) {
                if (board[rowPicked-i][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked-i] > 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked-i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked && i<=columnPicked; i++) {
                if (board[rowPicked+i][columnPicked-i] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked-i] > 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked - i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked-i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=rowPicked && i<=7-columnPicked; i++) {
                if (board[rowPicked-i][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked-i][columnPicked+i] > 0) {
                    optionsX[optionsFilled] = rowPicked - i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked-i][columnPicked+i] < 0) {
                    i = 100;
                }
            } for (int i=1; i<=7-rowPicked && i<=7-columnPicked; i++) {
                if (board[rowPicked+i][columnPicked+i] == 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                } else if (board[rowPicked+i][columnPicked+i] > 0) {
                    optionsX[optionsFilled] = rowPicked + i;
                    optionsY[optionsFilled] = columnPicked + i;
                    optionsFilled++;
                    i = 100;
                } else if (board[rowPicked+i][columnPicked+i] < 0) {
                    i = 100;
                }
            }
        }
        //White King
        else if (piece == 7 && whiteTurn) {
            if (columnPicked > 0) {
                if (board[rowPicked][columnPicked-1] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked-1] < 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            }
            if (columnPicked < 7) {
                if (board[rowPicked][columnPicked+1] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked+1] < 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            }
            if (rowPicked > 0) {
                if (board[rowPicked-1][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked-1][columnPicked] < 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                }
            }
            if (rowPicked < 7) {
                if (board[rowPicked+1][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked+1][columnPicked] < 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                }
            }
            if (rowPicked > 0 && columnPicked > 0) {
                if (board[rowPicked-1][columnPicked-1] == 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                } else if (board[rowPicked-1][columnPicked-1] < 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            }
            if (rowPicked < 7 && columnPicked > 0) {
                if (board[rowPicked+1][columnPicked-1] == 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                } else if (board[rowPicked+1][columnPicked-1] < 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            }
            if (rowPicked > 0 && columnPicked < 7) {
                if (board[rowPicked-1][columnPicked+1] == 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                } else if (board[rowPicked-1][columnPicked+1] < 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            }
            if (rowPicked < 7 && columnPicked < 7) {
                if (board[rowPicked+1][columnPicked+1] == 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                } else if (board[rowPicked+1][columnPicked+1] < 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            }
            if (rowPicked == 4 && columnPicked == 7 && !kingMoveWhite) {
                if (board[rowPicked+1][columnPicked] == 0 && board[rowPicked+2][columnPicked] == 0 && board[rowPicked+3][columnPicked] == 3 &&
                        !rookTwoMoveWhite && PKID.squareSafe(rowPicked, columnPicked, whiteTurn, false) &&
                        PKID.squareSafe(rowPicked+1, columnPicked, whiteTurn, false) &&
                        PKID.squareSafe(rowPicked+2, columnPicked, whiteTurn, false)) {
                    optionsX[optionsFilled] = rowPicked + 2;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                }
                if (board[rowPicked-1][columnPicked] == 0 && board[rowPicked-2][columnPicked] == 0 && board[rowPicked-4][columnPicked] == 2 &&
                        !rookOneMoveWhite && board[rowPicked-3][columnPicked] == 0 &&
                        PKID.squareSafe(rowPicked, columnPicked, whiteTurn, false) &&
                        PKID.squareSafe(rowPicked-1, columnPicked, whiteTurn, false) &&
                        PKID.squareSafe(rowPicked-2, columnPicked, whiteTurn, false)) {
                    optionsX[optionsFilled] = rowPicked - 2;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                }
            }
        }
        //Black King
        else if (piece == -7 && !whiteTurn) {
            if (columnPicked > 0) {
                if (board[rowPicked][columnPicked-1] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked-1] > 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            }
            if (columnPicked < 7) {
                if (board[rowPicked][columnPicked+1] == 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                } else if (board[rowPicked][columnPicked+1] > 0) {
                    optionsX[optionsFilled] = rowPicked;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            }
            if (rowPicked > 0) {
                if (board[rowPicked-1][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked-1][columnPicked] > 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                }
            }
            if (rowPicked < 7) {
                if (board[rowPicked+1][columnPicked] == 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                } else if (board[rowPicked+1][columnPicked] > 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                }
            }
            if (rowPicked > 0 && columnPicked > 0) {
                if (board[rowPicked-1][columnPicked-1] == 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                } else if (board[rowPicked-1][columnPicked-1] > 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            }
            if (rowPicked < 7 && columnPicked > 0) {
                if (board[rowPicked+1][columnPicked-1] == 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                } else if (board[rowPicked+1][columnPicked-1] > 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked - 1;
                    optionsFilled++;
                }
            }
            if (rowPicked > 0 && columnPicked < 7) {
                if (board[rowPicked-1][columnPicked+1] == 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                } else if (board[rowPicked-1][columnPicked+1] > 0) {
                    optionsX[optionsFilled] = rowPicked - 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            }
            if (rowPicked < 7 && columnPicked < 7) {
                if (board[rowPicked+1][columnPicked+1] == 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                } else if (board[rowPicked+1][columnPicked+1] > 0) {
                    optionsX[optionsFilled] = rowPicked + 1;
                    optionsY[optionsFilled] = columnPicked + 1;
                    optionsFilled++;
                }
            }
            if (rowPicked == 4 && columnPicked == 0 && !kingMoveBlack) {
                if (board[rowPicked+1][columnPicked] == 0 && board[rowPicked+2][columnPicked] == 0 && board[rowPicked+3][columnPicked] == -3 &&
                        !rookTwoMoveBlack && PKID.squareSafe(rowPicked, columnPicked, whiteTurn, false) &&
                        PKID.squareSafe(rowPicked+1, columnPicked, whiteTurn, false) &&
                        PKID.squareSafe(rowPicked+2, columnPicked, whiteTurn, false)) {
                    optionsX[optionsFilled] = rowPicked + 2;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                }
                if (board[rowPicked-1][columnPicked] == 0 && board[rowPicked-2][columnPicked] == 0 && board[rowPicked-4][columnPicked] == -2 &&
                        !rookOneMoveBlack && board[rowPicked-3][columnPicked] == 0 &&
                        PKID.squareSafe(rowPicked, columnPicked, whiteTurn, false) &&
                        PKID.squareSafe(rowPicked-1, columnPicked, whiteTurn, false) &&
                        PKID.squareSafe(rowPicked-2, columnPicked, whiteTurn, false)) {
                    optionsX[optionsFilled] = rowPicked - 2;
                    optionsY[optionsFilled] = columnPicked;
                    optionsFilled++;
                }
            }
        }
    }

    public void drawCurrentPosition() {
        drawBoard();
        imageMode(CENTER);
        for (int i = 0; i <= 7; i++){
            for (int j = 0; j <= 7; j++){
                if (board[i][j] == 1) {
                    image(whitePawn, i*100+50, j*100+50);
                } else if (board[i][j] == 2 || board[i][j] == 3 || board[i][j] == 8) {
                    image(whiteRook, i*100+50, j*100+50);
                } else if (board[i][j] == 4) {
                    image(whiteBishop, i*100+50, j*100+50);
                } else if (board[i][j] == 5) {
                    image(whiteKnight, i*100+50, j*100+50);
                } else if (board[i][j] == 6) {
                    image(whiteQueen, i*100+50, j*100+50);
                } else if (board[i][j] == 7) {
                    image(whiteKing, i*100+50, j*100+50);
                } else if (board[i][j] == -1) {
                    image(blackPawn, i*100+50, j*100+50);
                } else if (board[i][j] == -2 || board[i][j] == -3 || board[i][j] == -8) {
                    image(blackRook, i*100+50, j*100+50);
                } else if (board[i][j] == -4) {
                    image(blackBishop, i*100+50, j*100+50);
                } else if (board[i][j] == -5) {
                    image(blackKnight, i*100+50, j*100+50);
                } else if (board[i][j] == -6) {
                    image(blackQueen, i*100+50, j*100+50);
                } else if (board[i][j] == -7) {
                    image(blackKing, i*100+50, j*100+50);
                }
            }
        }
    }

    public void showMovementOptions() {
        for (int i = 0; i <= 20; i++) {
            if (optionsX[i] != -1000) {
                fill(0, 255, 255);
                ellipse(optionsX[i]*100+50, optionsY[i]*100+50, 20, 20);
            }
        }
    }

    public void showKingDanger() {
        if (kingDanger || inCheck) {
            strokeWeight(10);
            stroke(255, 0, 0);
            noFill();
            square(findKingX(whiteTurn)*100+5, findKingY(whiteTurn)*100+5, 90);
            strokeWeight(0);
            stroke(0);
        }
    }

    public void showPromote() {
        if (whitePromote) {
            strokeWeight(2);
            fill (255, 255, 255);
            rect(190, 90, 420, 120);
            strokeWeight(0);
            imageMode(CENTER);
            image(whiteQueen, 250, 150);
            image(whiteRook, 350, 150);
            image(whiteBishop, 450, 150);
            image(whiteKnight, 550, 150);
        } else if (blackPromote) {
            strokeWeight(2);
            fill (255, 255, 255);
            rect(190, 590, 420, 120);
            strokeWeight(0);
            imageMode(CENTER);
            image(blackQueen, 250, 650);
            image(blackRook, 350, 650);
            image(blackBishop, 450, 650);
            image(blackKnight, 550, 650);
        }
    }

    public void promote(int x, int y) {
        if (x > 225 && x < 275 && y > 125 && y < 175) {
            board[newRowPicked][newColumnPicked] = 6;
            whitePromote = false;
            checkEnding();
        } else if (x > 325 && x < 375 && y > 125 && y < 175) {
            board[newRowPicked][newColumnPicked] = 8;
            whitePromote = false;
            checkEnding();
        } else if (x > 425 && x < 475 && y > 125 && y < 175) {
            board[newRowPicked][newColumnPicked] = 4;
            whitePromote = false;
            checkEnding();
        } else if (x > 525 && x < 575 && y > 125 && y < 175) {
            board[newRowPicked][newColumnPicked] = 5;
            whitePromote = false;
            checkEnding();
        }

        else if (x > 225 && x < 275 && y > 625 && y < 675) {
            board[newRowPicked][newColumnPicked] = -6;
            blackPromote = false;
            checkEnding();
        } else if (x > 325 && x < 375 && y > 625 && y < 675) {
            board[newRowPicked][newColumnPicked] = -8;
            blackPromote = false;
            checkEnding();
        } else if (x > 425 && x < 475 && y > 625 && y < 675) {
            board[newRowPicked][newColumnPicked] = -4;
            blackPromote = false;
            checkEnding();
        } else if (x > 525 && x < 575 && y > 625 && y < 675) {
            board[newRowPicked][newColumnPicked] = -5;
            blackPromote = false;
            checkEnding();
        }
    }

    public void movePiece(int rowPicked, int columnPicked, int newRowPicked, int newColumnPicked) {
        PutKingInDanger PKID = new PutKingInDanger();
        CheckCheckmate CC = new CheckCheckmate();

        mateType = 0;
        repetitionType = 0;
        captureWasMade = false;
        pieceThatIsMoving = board[rowPicked][columnPicked];
        originalPiece = board[newRowPicked][newColumnPicked];

        //Check if a piece was captured
        if ((board[newRowPicked][newColumnPicked] != 0) || (thisWasEnPassant)) {
            captureWasMade = true;
        }

        //Check if Castling, if not move the piece normally
        if (pieceThatIsMoving == 7 && rowPicked == 4 && columnPicked == 7 && newRowPicked == 6 && newColumnPicked == 7) {
            board[newRowPicked][newColumnPicked] = pieceThatIsMoving;
            board[rowPicked][columnPicked]=0;
            board[5][7] = 3;
            board[7][7] = 0;
        } else if (pieceThatIsMoving == 7 && rowPicked == 4 && columnPicked == 7 && newRowPicked == 2 && newColumnPicked == 7) {
            board[newRowPicked][newColumnPicked] = pieceThatIsMoving;
            board[rowPicked][columnPicked]=0;
            board[3][7] = 2;
            board[0][7] = 0;
        } else if (pieceThatIsMoving == -7 && rowPicked == 4 && columnPicked == 0 && newRowPicked == 6 && newColumnPicked == 0) {
            board[newRowPicked][newColumnPicked] = pieceThatIsMoving;
            board[rowPicked][columnPicked]=0;
            board[5][0] = -3;
            board[7][0] = 0;
        } else if (pieceThatIsMoving == -7 && rowPicked == 4 && columnPicked == 0 && newRowPicked == 2 && newColumnPicked == 0) {
            board[newRowPicked][newColumnPicked] = pieceThatIsMoving;
            board[rowPicked][columnPicked]=0;
            board[3][0] = -2;
            board[0][0] = 0;
        } else {
            board[newRowPicked][newColumnPicked] = pieceThatIsMoving;
            board[rowPicked][columnPicked] = 0;
        }

        //Check if pawn moved up 2 squares, if so, allow en passant
        allowEnPassant = (pieceThatIsMoving == 1 && newRowPicked == rowPicked && columnPicked - newColumnPicked == 2) ||
                (pieceThatIsMoving == -1 && newRowPicked == rowPicked && newColumnPicked - columnPicked == 2);
        if (newRowPicked < 7) {
            enPassantLeft = (allowEnPassant && (board[newRowPicked+1][newColumnPicked] == 1 || board[newRowPicked+1][newColumnPicked] == -1));
        }
        if (newRowPicked > 0) {
            enPassantRight = (allowEnPassant && (board[newRowPicked-1][newColumnPicked] == 1 || board[newRowPicked-1][newColumnPicked] == -1));
        }
        //Move EnPassant
        if (pieceThatIsMoving == 1 && thisWasEnPassant) {
            board[newRowPicked][newColumnPicked+1] = 0;
        } else if (pieceThatIsMoving == -1 && thisWasEnPassant) {
            board[newRowPicked][newColumnPicked-1] = 0;
        }

        //Check if the move leaves the king safe
        if (!PKID.squareSafe(findKingX(whiteTurn), findKingY(whiteTurn), whiteTurn, false)) {
            board[rowPicked][columnPicked] = pieceThatIsMoving;
            board[newRowPicked][newColumnPicked] = originalPiece;
            if (whiteTurn && thisWasEnPassant) {
                board[newRowPicked][newColumnPicked+1] = -1;
                allowEnPassant = true;
            } else if (!whiteTurn && thisWasEnPassant) {
                board[newRowPicked][newColumnPicked-1] = 1;
                allowEnPassant = true;
            }
            captureWasMade = false;
            kingDanger = true;
        }
        else {
            clearOptions();
            whiteTurn = !whiteTurn;
            thisWasEnPassant = false;
            kingDanger = false;

            //Check if first time rook or king move
            if (pieceThatIsMoving == 2) {
                rookOneMoveWhite = true;
            } else if (pieceThatIsMoving == 3) {
                rookTwoMoveWhite = true;
            } else if (pieceThatIsMoving == -2) {
                rookOneMoveBlack = true;
            } else if (pieceThatIsMoving == -3) {
                rookTwoMoveBlack = true;
            } else if (pieceThatIsMoving == 7) {
                kingMoveWhite = true;
            } else if (pieceThatIsMoving == -7) {
                kingMoveBlack = true;
            }

            //Check if a pawn is being promoted
            whitePromote = (pieceThatIsMoving == 1 && columnPicked == 1 && newColumnPicked == 0);
            blackPromote = (pieceThatIsMoving == -1 && columnPicked == 6 && newColumnPicked == 7);

            //Check if in check
            if (PKID.squareSafe(findKingX(whiteTurn), findKingY(whiteTurn), whiteTurn, false)) {
                inCheck = false;
            } else if (!PKID.squareSafe(findKingX(whiteTurn), findKingY(whiteTurn), whiteTurn, false)) {
                inCheck = true;
            }

            //Check if an ending has been reached
            mateType = CC.checkCheckmate(findKingX(whiteTurn), findKingY(whiteTurn), whiteTurn);
            repetitionType = SSB.checkRepetition(pieceThatIsMoving, captureWasMade);
            if (mateType == 1) {
                if (whiteTurn) {
                    currentState = GameState.BLACKWIN;
                } else {
                    currentState = GameState.WHITEWIN;
                }
                howEnd = PossibleEndings.CHECKMATE;
                drawCurrentPosition();
                showKingDanger();
            } else if (mateType == 2) {
                currentState = GameState.DRAW;
                howEnd = PossibleEndings.STALEMATE;
                drawCurrentPosition();
            } else if (checkInsufficient()) {
                currentState = GameState.DRAW;
                howEnd = PossibleEndings.INSUFFICIENT;
                drawCurrentPosition();
            } else if (repetitionType == 1) {
                currentState = GameState.DRAW;
                howEnd = PossibleEndings.THREEMOVEREPETITION;
                drawCurrentPosition();
            } else if (repetitionType == 2) {
                currentState = GameState.DRAW;
                howEnd = PossibleEndings.FIFTYMOVERULE;
                drawCurrentPosition();
            }
        }
    }

    public void checkEnding() {
        //Doesn't check SSB endings, only used if an ending is reached on a promotion move
        CheckCheckmate CC = new CheckCheckmate();
        mateType = CC.checkCheckmate(findKingX(whiteTurn), findKingY(whiteTurn), whiteTurn);
        if (mateType == 1) {
            if (whiteTurn) {
                currentState = GameState.BLACKWIN;
            } else {
                currentState = GameState.WHITEWIN;
            }
            howEnd = PossibleEndings.CHECKMATE;
            drawCurrentPosition();
            showKingDanger();
        } else if (mateType == 2) {
            currentState = GameState.DRAW;
            howEnd = PossibleEndings.STALEMATE;
            drawCurrentPosition();
        } else if (checkInsufficient()) {
            currentState = GameState.DRAW;
            howEnd = PossibleEndings.INSUFFICIENT;
            drawCurrentPosition();
        }
    }

    public boolean checkInsufficient() {
        isInsufficient = false;
        pieceValuesWhite = 0;
        pieceValuesBlack = 0;
        for (int i = 0; i<=7; i++) {
            for (int j = 0; j <= 7; j++) {
                if (board[i][j] == 1 || board[i][j] == -1 || board[i][j] == 2 || board[i][j] == -2 || board[i][j] == 3 || board[i][j] == -3 || board[i][j] == 6 || board[i][j] == -6) {
                    return false;
                } else if (board[i][j] == 4) {
                    pieceValuesWhite += 3;
                } else if (board[i][j] == -4) {
                    pieceValuesBlack += 3;
                } else if (board[i][j] == 5) {
                    pieceValuesWhite += 2;
                } else if (board[i][j] == -5) {
                    pieceValuesBlack += 2;
                }
            }
        }

        if (pieceValuesWhite < 5 && pieceValuesBlack < 5) {
            isInsufficient = true;
        }

        return isInsufficient;
    }

    public void clearOptions() {
        for (int i = 0; i <= 90; i++) {
            optionsX[i] = -1000;
            optionsY[i] = -1000;
        }
        optionsFilled = 0;
    }

    public int findKingX(boolean white) {
        kingX = -1000;
        for (int i = 0; i<=7; i++) {
            for (int j = 0; j<=7; j++) {
                if (board[i][j] == 7 && white) {
                    kingX = i;
                } else if (board[i][j] == -7 && !white) {
                    kingX = i;
                }
            }
        }
        return kingX;
    }
    public int findKingY(boolean white) {
        kingY = -1000;
        for (int i = 0; i<=7; i++) {
            for (int j = 0; j<=7; j++) {
                if (board[i][j] == 7 && white) {
                    kingY = j;
                } else if (board[i][j] == -7 && !white) {
                    kingY = j;
                }
            }
        }
        return kingY;
    }
}
