package com.purplefrogg;

import java.util.Arrays;

public class SmallSaveBoard {
    int[][][] saveEvents = new int[102][8][8];
    int eventsSaved;
    int timesRepeated;
    boolean startingPosSaved;
    int[][] startingPosition = {
            {-2, -1, 0, 0, 0, 0, 1, 2},
            {-5, -1, 0, 0, 0, 0, 1, 5},
            {-4, -1, 0, 0, 0, 0, 1, 4},
            {-6, -1, 0, 0, 0, 0, 1, 6},
            {-7, -1, 0, 0, 0, 0, 1, 7},
            {-4, -1, 0, 0, 0, 0, 1, 4},
            {-5, -1, 0, 0, 0, 0, 1, 5},
            {-3, -1, 0, 0, 0, 0, 1, 3}
    };
    int[][] emptyBoard = {
            {0, 0, 0, 0, 0, 0, 0, 0},
            {0, 0, 0, 0, 0, 0, 0, 0},
            {0, 0, 0, 0, 0, 0, 0, 0},
            {0, 0, 0, 0, 0, 0, 0, 0},
            {0, 0, 0, 0, 0, 0, 0, 0},
            {0, 0, 0, 0, 0, 0, 0, 0},
            {0, 0, 0, 0, 0, 0, 0, 0},
            {0, 0, 0, 0, 0, 0, 0, 0}
    };

    public int checkRepetition(int movedPiece, boolean captureMade) {
        timesRepeated = 0;

        //If pawn moved or piece was captured, clear the events
        if ((movedPiece == 1 || movedPiece == -1) || (captureMade)) {
            clearSmallSaveBoard();
        }
        //Clone current board position to one slot of saveEvents
        for (int i = 0; i < 8; i++) {
            saveEvents[eventsSaved][i] = Main.board[i].clone();
        }
        eventsSaved++;

        for (int i = 0; i < saveEvents.length; i++) {
            timesRepeated = 0;
            for (int j = i+1; i+j < saveEvents.length; j++) {
                if ((Arrays.deepEquals(saveEvents[i], saveEvents[j])) && (!Arrays.deepEquals(saveEvents[i], emptyBoard) && !Arrays.deepEquals(saveEvents[j], emptyBoard))) {
                    timesRepeated++;
                    if (timesRepeated == 2) return 1;
                }
            }
        }

        /*Why 101 and 102? Slot 0 of saveEvents is always taken by the move where pawn was moved or capture was made, and since
        eventsSaved++ is right after each save, when 100 slots are taken up, eventsSaved will be 101. Saving the starting position
        also takes up 1 slot, so gotta add one if the starting position is saved.*/
        if ((!startingPosSaved && eventsSaved == 101) || (startingPosSaved && eventsSaved == 102)) {
            return 2;
        }

        return 0;
    }

    public void addStartingPosition() {
        clearSmallSaveBoard();
        //Set slot 0 of saveEvents to starting position, this is cleared after clearSmallSaveBoard is run
        for(int i = 0; i < 8; i++) {
            saveEvents[0][i] = startingPosition[i].clone();
        }
        eventsSaved = 1;
        startingPosSaved = true;
    }

    public void clearSmallSaveBoard() {
        eventsSaved = 0;
        startingPosSaved = false;
        for (int i = 0; i < saveEvents.length; i++) {
            for (int j = 0; j < saveEvents[i].length; j++) {
                for (int k = 0; k < saveEvents[i][j].length; k++) {
                    saveEvents[i][j][k] = 0;
                }
            }
        }
    }
}