/*
 * Decompiled with CFR 0.152.
 */
package com.purplefrogg;

import com.purplefrogg.CheckCheckmate;
import com.purplefrogg.PutKingInDanger;
import com.purplefrogg.SmallSaveBoard;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public class Main
extends PApplet {
    static int[][] board = new int[8][8];
    int rowPicked;
    int columnPicked;
    int newRowPicked;
    int newColumnPicked;
    boolean whiteTurn;
    int[] optionsX = new int[100];
    int[] optionsY = new int[100];
    int pieceThatIsMoving;
    int originalPiece;
    int optionsFilled;
    boolean rookOneMoveWhite;
    boolean rookTwoMoveWhite;
    boolean rookOneMoveBlack;
    boolean rookTwoMoveBlack;
    boolean kingMoveWhite;
    boolean kingMoveBlack;
    boolean hovering;
    static boolean allowEnPassant;
    static boolean enPassantLeft;
    static boolean enPassantRight;
    boolean thisWasEnPassant;
    boolean kingDanger;
    boolean inCheck;
    boolean isInsufficient;
    boolean captureWasMade;
    boolean whitePromote;
    boolean blackPromote;
    int mateType;
    int repetitionType;
    int pieceValuesWhite;
    int pieceValuesBlack;
    int kingX;
    int kingY;
    SmallSaveBoard SSB = new SmallSaveBoard();
    PImage whitePawn;
    PImage whiteBishop;
    PImage whiteKnight;
    PImage whiteRook;
    PImage whiteQueen;
    PImage whiteKing;
    PImage blackPawn;
    PImage blackBishop;
    PImage blackKnight;
    PImage blackRook;
    PImage blackQueen;
    PImage blackKing;
    static GameState currentState;
    static PossibleEndings howEnd;
    PFont winBigFont;
    PFont winFont;
    int winFillColor;

    public static void main(String[] args) {
        PApplet.main("com.purplefrogg.Main");
    }

    @Override
    public void settings() {
        this.size(800, 800);
    }

    @Override
    public void setup() {
        this.surface.setTitle("Chess");
        this.whiteTurn = true;
        this.optionsFilled = 0;
        this.rookOneMoveWhite = false;
        this.rookTwoMoveWhite = false;
        this.rookOneMoveBlack = false;
        this.rookTwoMoveBlack = false;
        this.kingMoveWhite = false;
        this.kingMoveBlack = false;
        allowEnPassant = false;
        enPassantLeft = false;
        enPassantRight = false;
        this.thisWasEnPassant = false;
        this.kingDanger = false;
        this.inCheck = false;
        this.isInsufficient = false;
        this.pieceValuesWhite = 0;
        this.pieceValuesBlack = 0;
        this.strokeWeight(0.0f);
        currentState = GameState.RUNNING;
        this.setStartingPosition();
        this.drawCurrentPosition();
        this.clearOptions();
    }

    @Override
    public void draw() {
        switch (currentState) {
            case RUNNING: {
                this.drawCurrentPosition();
                this.showMovementOptions();
                this.showKingDanger();
                this.hover();
                this.showPromote();
                break;
            }
            case BLACKWIN: 
            case WHITEWIN: 
            case DRAW: {
                this.drawEndScreen();
            }
        }
    }

    @Override
    public void mousePressed() {
        switch (currentState) {
            case RUNNING: {
                if (this.mouseX < 0 || this.mouseX > 800 || this.mouseY < 0 || this.mouseY > 800) break;
                if (this.whitePromote || this.blackPromote) {
                    this.promote(this.mouseX, this.mouseY);
                    break;
                }
                if (board[this.mouseX / 100][this.mouseY / 100] > 0 && this.whiteTurn) {
                    this.clearOptions();
                    this.rowPicked = this.mouseX / 100;
                    this.columnPicked = this.mouseY / 100;
                    this.hovering = true;
                    this.findLegalMoves(this.rowPicked, this.columnPicked);
                    break;
                }
                if (board[this.mouseX / 100][this.mouseY / 100] < 0 && !this.whiteTurn) {
                    this.clearOptions();
                    this.rowPicked = this.mouseX / 100;
                    this.columnPicked = this.mouseY / 100;
                    this.hovering = true;
                    this.findLegalMoves(this.rowPicked, this.columnPicked);
                    break;
                }
                if (board[this.mouseX / 100][this.mouseY / 100] <= 0 && this.whiteTurn) {
                    this.newRowPicked = this.mouseX / 100;
                    this.newColumnPicked = this.mouseY / 100;
                    for (int i = 0; i <= 20; ++i) {
                        if (this.newRowPicked != this.optionsX[i] || this.newColumnPicked != this.optionsY[i]) continue;
                        this.movePiece(this.rowPicked, this.columnPicked, this.newRowPicked, this.newColumnPicked);
                    }
                } else {
                    if (board[this.mouseX / 100][this.mouseY / 100] < 0 || this.whiteTurn) break;
                    this.newRowPicked = this.mouseX / 100;
                    this.newColumnPicked = this.mouseY / 100;
                    for (int i = 0; i <= 20; ++i) {
                        if (this.newRowPicked != this.optionsX[i] || this.newColumnPicked != this.optionsY[i]) continue;
                        this.movePiece(this.rowPicked, this.columnPicked, this.newRowPicked, this.newColumnPicked);
                    }
                }
                break;
            }
            case BLACKWIN: 
            case WHITEWIN: 
            case DRAW: {
                if (this.mouseX <= 300 || this.mouseX >= 500 || this.mouseY <= 520 || this.mouseY >= 610) break;
                this.setup();
            }
        }
    }

    @Override
    public void mouseReleased() {
        block6: {
            if (currentState != GameState.RUNNING) break block6;
            this.hovering = false;
            if (this.mouseX >= 0 && this.mouseX <= 800 && this.mouseY >= 0 && this.mouseY <= 800) {
                if (board[this.mouseX / 100][this.mouseY / 100] <= 0 && this.whiteTurn) {
                    this.newRowPicked = this.mouseX / 100;
                    this.newColumnPicked = this.mouseY / 100;
                    for (int i = 0; i <= 20; ++i) {
                        if (this.newRowPicked != this.optionsX[i] || this.newColumnPicked != this.optionsY[i]) continue;
                        this.movePiece(this.rowPicked, this.columnPicked, this.newRowPicked, this.newColumnPicked);
                    }
                } else if (board[this.mouseX / 100][this.mouseY / 100] >= 0 && !this.whiteTurn) {
                    this.newRowPicked = this.mouseX / 100;
                    this.newColumnPicked = this.mouseY / 100;
                    for (int i = 0; i <= 20; ++i) {
                        if (this.newRowPicked != this.optionsX[i] || this.newColumnPicked != this.optionsY[i]) continue;
                        this.movePiece(this.rowPicked, this.columnPicked, this.newRowPicked, this.newColumnPicked);
                    }
                }
            }
        }
    }

    public void hover() {
        if (this.hovering) {
            int piece = board[this.rowPicked][this.columnPicked];
            if (this.rowPicked % 2 == 1 && this.columnPicked % 2 == 1 || this.rowPicked % 2 == 0 && this.columnPicked % 2 == 0) {
                this.fill(200.0f, 200.0f, 200.0f);
            } else {
                this.fill(100.0f, 100.0f, 100.0f);
            }
            this.rect(this.rowPicked * 100, this.columnPicked * 100, 100.0f, 100.0f);
            this.imageMode(3);
            if (piece == 1) {
                this.image(this.whitePawn, this.mouseX, this.mouseY);
            } else if (piece == 2 || piece == 3 || piece == 8) {
                this.image(this.whiteRook, this.mouseX, this.mouseY);
            } else if (piece == 4) {
                this.image(this.whiteBishop, this.mouseX, this.mouseY);
            } else if (piece == 5) {
                this.image(this.whiteKnight, this.mouseX, this.mouseY);
            } else if (piece == 6) {
                this.image(this.whiteQueen, this.mouseX, this.mouseY);
            } else if (piece == 7) {
                this.image(this.whiteKing, this.mouseX, this.mouseY);
            } else if (piece == -1) {
                this.image(this.blackPawn, this.mouseX, this.mouseY);
            } else if (piece == -2 || piece == -3 || piece == -8) {
                this.image(this.blackRook, this.mouseX, this.mouseY);
            } else if (piece == -4) {
                this.image(this.blackBishop, this.mouseX, this.mouseY);
            } else if (piece == -5) {
                this.image(this.blackKnight, this.mouseX, this.mouseY);
            } else if (piece == -6) {
                this.image(this.blackQueen, this.mouseX, this.mouseY);
            } else if (piece == -7) {
                this.image(this.blackKing, this.mouseX, this.mouseY);
            }
        }
    }

    public void drawBoard() {
        for (int i = 0; i <= 7; ++i) {
            for (int j = 0; j <= 7; ++j) {
                int xBoardPos = i * 100;
                int yBoardPos = j * 100;
                if (j % 2 == 0 && i % 2 == 0) {
                    this.fill(200.0f, 200.0f, 200.0f);
                } else if (j % 2 != 0 && i % 2 == 0) {
                    this.fill(100.0f, 100.0f, 100.0f);
                } else if (j % 2 == 0) {
                    this.fill(100.0f, 100.0f, 100.0f);
                } else {
                    this.fill(200.0f, 200.0f, 200.0f);
                }
                this.square(xBoardPos, yBoardPos, 100.0f);
            }
        }
    }

    public void setStartingPosition() {
        int i;
        for (i = 0; i <= 7; ++i) {
            for (int j = 0; j <= 7; ++j) {
                Main.board[i][j] = 0;
            }
        }
        Main.board[0][0] = -2;
        Main.board[1][0] = -5;
        Main.board[2][0] = -4;
        Main.board[3][0] = -6;
        Main.board[4][0] = -7;
        Main.board[5][0] = -4;
        Main.board[6][0] = -5;
        Main.board[7][0] = -3;
        for (i = 0; i <= 7; ++i) {
            Main.board[i][1] = -1;
        }
        Main.board[0][7] = 2;
        Main.board[1][7] = 5;
        Main.board[2][7] = 4;
        Main.board[3][7] = 6;
        Main.board[4][7] = 7;
        Main.board[5][7] = 4;
        Main.board[6][7] = 5;
        Main.board[7][7] = 3;
        for (i = 0; i <= 7; ++i) {
            Main.board[i][6] = 1;
        }
        this.whitePawn = this.loadImage("White Pawn.png");
        this.whiteBishop = this.loadImage("White Bishop.png");
        this.whiteKnight = this.loadImage("White Knight.png");
        this.whiteRook = this.loadImage("White Rook.png");
        this.whiteQueen = this.loadImage("White Queen.png");
        this.whiteKing = this.loadImage("White King.png");
        this.blackPawn = this.loadImage("Black Pawn.png");
        this.blackBishop = this.loadImage("Black Bishop.png");
        this.blackKnight = this.loadImage("Black Knight.png");
        this.blackRook = this.loadImage("Black Rook.png");
        this.blackQueen = this.loadImage("Black Queen.png");
        this.blackKing = this.loadImage("Black King.png");
        this.surface.setIcon(this.whitePawn);
        this.SSB.addStartingPosition();
    }

    public void drawEndScreen() {
        this.fill(213.0f, 176.0f, 124.0f);
        this.rect(190.0f, 90.0f, 420.0f, 620.0f);
        this.textAlign(3);
        this.winBigFont = this.createFont("Arial", 50.0f);
        this.winFont = this.createFont("Arial", 25.0f);
        this.textFont(this.winBigFont);
        switch (currentState) {
            case WHITEWIN: {
                this.winFillColor = 255;
                this.fill(this.winFillColor);
                this.text("White Wins", 400.0f, 180.0f);
                break;
            }
            case BLACKWIN: {
                this.winFillColor = 0;
                this.fill(this.winFillColor);
                this.text("Black Wins", 400.0f, 180.0f);
                break;
            }
            case DRAW: {
                this.winFillColor = 128;
                this.fill(this.winFillColor);
                this.text("Draw", 400.0f, 180.0f);
            }
        }
        this.textFont(this.winFont);
        switch (howEnd) {
            case CHECKMATE: {
                this.fill(this.winFillColor);
                this.text("By Checkmate", 400.0f, 220.0f);
                break;
            }
            case STALEMATE: {
                this.fill(this.winFillColor);
                this.text("By Stalemate", 400.0f, 220.0f);
                break;
            }
            case INSUFFICIENT: {
                this.fill(this.winFillColor);
                this.text("Insufficient Material", 400.0f, 220.0f);
                break;
            }
            case THREEMOVEREPETITION: {
                this.fill(this.winFillColor);
                this.text("Three Move Repetition", 400.0f, 220.0f);
                break;
            }
            case FIFTYMOVERULE: {
                this.fill(this.winFillColor);
                this.text("Fifty Move Rule", 400.0f, 220.0f);
            }
        }
        this.fill(79.0f, 89.0f, 76.0f);
        this.rect(300.0f, 520.0f, 200.0f, 90.0f);
        this.textFont(this.winFont);
        this.fill(255.0f, 255.0f, 255.0f);
        this.text("Play Again", 400.0f, 570.0f);
    }

    public void findLegalMoves(int rowPicked, int columnPicked) {
        PutKingInDanger PKID = new PutKingInDanger();
        int piece = board[rowPicked][columnPicked];
        if (piece == 1 && this.whiteTurn) {
            if (columnPicked != 0) {
                if (board[rowPicked][columnPicked - 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
                if (board[rowPicked][columnPicked - 1] == 0 && columnPicked == 6 && board[rowPicked][columnPicked - 2] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - 2;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked != 0 && columnPicked != 0) {
                if (board[rowPicked - 1][columnPicked - 1] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
                if (allowEnPassant && columnPicked == 3 && board[rowPicked - 1][columnPicked] == -1 && enPassantLeft) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                    this.thisWasEnPassant = true;
                }
            }
            if (rowPicked != 7 && columnPicked != 0) {
                if (board[rowPicked + 1][columnPicked - 1] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
                if (allowEnPassant && columnPicked == 3 && board[rowPicked + 1][columnPicked] == -1 && enPassantRight) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                    this.thisWasEnPassant = true;
                }
            }
        } else if (piece == -1 && !this.whiteTurn) {
            if (columnPicked != 7) {
                if (board[rowPicked][columnPicked + 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
                if (board[rowPicked][columnPicked + 1] == 0 && columnPicked == 1 && board[rowPicked][columnPicked + 2] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + 2;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked != 0 && columnPicked != 7) {
                if (board[rowPicked - 1][columnPicked + 1] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
                if (allowEnPassant && columnPicked == 4 && board[rowPicked - 1][columnPicked] == 1 && enPassantLeft) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                    this.thisWasEnPassant = true;
                }
            }
            if (rowPicked != 7 && columnPicked != 7) {
                if (board[rowPicked + 1][columnPicked + 1] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
                if (allowEnPassant && columnPicked == 4 && board[rowPicked + 1][columnPicked] == 1 && enPassantRight) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                    this.thisWasEnPassant = true;
                }
            }
        } else if (piece == 4 && this.whiteTurn) {
            int i;
            for (i = 1; i <= rowPicked && i <= columnPicked; ++i) {
                if (board[rowPicked - i][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked - i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked - i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked && i <= columnPicked; ++i) {
                if (board[rowPicked + i][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked - i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked - i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked && i <= 7 - columnPicked; ++i) {
                if (board[rowPicked - i][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked + i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked + i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked && i <= 7 - columnPicked; ++i) {
                if (board[rowPicked + i][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked + i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked + i] <= 0) continue;
                i = 100;
            }
        } else if (piece == -4 && !this.whiteTurn) {
            int i;
            for (i = 1; i <= rowPicked && i <= columnPicked; ++i) {
                if (board[rowPicked - i][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked - i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked - i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked && i <= columnPicked; ++i) {
                if (board[rowPicked + i][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked - i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked - i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked && i <= 7 - columnPicked; ++i) {
                if (board[rowPicked - i][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked + i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked + i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked && i <= 7 - columnPicked; ++i) {
                if (board[rowPicked + i][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked + i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked + i] >= 0) continue;
                i = 100;
            }
        } else if (piece == 5 && this.whiteTurn) {
            if (rowPicked > 0 && columnPicked > 1 && board[rowPicked - 1][columnPicked - 2] <= 0) {
                this.optionsX[this.optionsFilled] = rowPicked - 1;
                this.optionsY[this.optionsFilled] = columnPicked - 2;
                ++this.optionsFilled;
            }
            if (rowPicked < 7 && columnPicked > 1 && board[rowPicked + 1][columnPicked - 2] <= 0) {
                this.optionsX[this.optionsFilled] = rowPicked + 1;
                this.optionsY[this.optionsFilled] = columnPicked - 2;
                ++this.optionsFilled;
            }
            if (rowPicked > 0 && columnPicked < 6 && board[rowPicked - 1][columnPicked + 2] <= 0) {
                this.optionsX[this.optionsFilled] = rowPicked - 1;
                this.optionsY[this.optionsFilled] = columnPicked + 2;
                ++this.optionsFilled;
            }
            if (rowPicked < 7 && columnPicked < 6 && board[rowPicked + 1][columnPicked + 2] <= 0) {
                this.optionsX[this.optionsFilled] = rowPicked + 1;
                this.optionsY[this.optionsFilled] = columnPicked + 2;
                ++this.optionsFilled;
            }
            if (rowPicked > 1 && columnPicked > 0 && board[rowPicked - 2][columnPicked - 1] <= 0) {
                this.optionsX[this.optionsFilled] = rowPicked - 2;
                this.optionsY[this.optionsFilled] = columnPicked - 1;
                ++this.optionsFilled;
            }
            if (rowPicked > 1 && columnPicked < 7 && board[rowPicked - 2][columnPicked + 1] <= 0) {
                this.optionsX[this.optionsFilled] = rowPicked - 2;
                this.optionsY[this.optionsFilled] = columnPicked + 1;
                ++this.optionsFilled;
            }
            if (rowPicked < 6 && columnPicked > 0 && board[rowPicked + 2][columnPicked - 1] <= 0) {
                this.optionsX[this.optionsFilled] = rowPicked + 2;
                this.optionsY[this.optionsFilled] = columnPicked - 1;
                ++this.optionsFilled;
            }
            if (rowPicked < 6 && columnPicked < 7 && board[rowPicked + 2][columnPicked + 1] <= 0) {
                this.optionsX[this.optionsFilled] = rowPicked + 2;
                this.optionsY[this.optionsFilled] = columnPicked + 1;
                ++this.optionsFilled;
            }
        } else if (piece == -5 && !this.whiteTurn) {
            if (rowPicked > 0 && columnPicked > 1 && board[rowPicked - 1][columnPicked - 2] >= 0) {
                this.optionsX[this.optionsFilled] = rowPicked - 1;
                this.optionsY[this.optionsFilled] = columnPicked - 2;
                ++this.optionsFilled;
            }
            if (rowPicked < 7 && columnPicked > 1 && board[rowPicked + 1][columnPicked - 2] >= 0) {
                this.optionsX[this.optionsFilled] = rowPicked + 1;
                this.optionsY[this.optionsFilled] = columnPicked - 2;
                ++this.optionsFilled;
            }
            if (rowPicked > 0 && columnPicked < 6 && board[rowPicked - 1][columnPicked + 2] >= 0) {
                this.optionsX[this.optionsFilled] = rowPicked - 1;
                this.optionsY[this.optionsFilled] = columnPicked + 2;
                ++this.optionsFilled;
            }
            if (rowPicked < 7 && columnPicked < 6 && board[rowPicked + 1][columnPicked + 2] >= 0) {
                this.optionsX[this.optionsFilled] = rowPicked + 1;
                this.optionsY[this.optionsFilled] = columnPicked + 2;
                ++this.optionsFilled;
            }
            if (rowPicked > 1 && columnPicked > 0 && board[rowPicked - 2][columnPicked - 1] >= 0) {
                this.optionsX[this.optionsFilled] = rowPicked - 2;
                this.optionsY[this.optionsFilled] = columnPicked - 1;
                ++this.optionsFilled;
            }
            if (rowPicked > 1 && columnPicked < 7 && board[rowPicked - 2][columnPicked + 1] >= 0) {
                this.optionsX[this.optionsFilled] = rowPicked - 2;
                this.optionsY[this.optionsFilled] = columnPicked + 1;
                ++this.optionsFilled;
            }
            if (rowPicked < 6 && columnPicked > 0 && board[rowPicked + 2][columnPicked - 1] >= 0) {
                this.optionsX[this.optionsFilled] = rowPicked + 2;
                this.optionsY[this.optionsFilled] = columnPicked - 1;
                ++this.optionsFilled;
            }
            if (rowPicked < 6 && columnPicked < 7 && board[rowPicked + 2][columnPicked + 1] >= 0) {
                this.optionsX[this.optionsFilled] = rowPicked + 2;
                this.optionsY[this.optionsFilled] = columnPicked + 1;
                ++this.optionsFilled;
            }
        } else if (piece == 2 && this.whiteTurn || piece == 3 && this.whiteTurn || piece == 8 && this.whiteTurn) {
            int i;
            for (i = 1; i <= columnPicked; ++i) {
                if (board[rowPicked][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked][columnPicked - i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked][columnPicked - i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - columnPicked; ++i) {
                if (board[rowPicked][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked][columnPicked + i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked][columnPicked + i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked; ++i) {
                if (board[rowPicked - i][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked; ++i) {
                if (board[rowPicked + i][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked] <= 0) continue;
                i = 100;
            }
        } else if (piece == -2 && !this.whiteTurn || piece == -3 && !this.whiteTurn || piece == -8 && !this.whiteTurn) {
            int i;
            for (i = 1; i <= columnPicked; ++i) {
                if (board[rowPicked][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked][columnPicked - i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked][columnPicked - i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - columnPicked; ++i) {
                if (board[rowPicked][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked][columnPicked + i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked][columnPicked + i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked; ++i) {
                if (board[rowPicked - i][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked; ++i) {
                if (board[rowPicked + i][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked] >= 0) continue;
                i = 100;
            }
        } else if (piece == 6 && this.whiteTurn) {
            int i;
            for (i = 1; i <= columnPicked; ++i) {
                if (board[rowPicked][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked][columnPicked - i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked][columnPicked - i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - columnPicked; ++i) {
                if (board[rowPicked][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked][columnPicked + i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked][columnPicked + i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked; ++i) {
                if (board[rowPicked - i][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked; ++i) {
                if (board[rowPicked + i][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked && i <= columnPicked; ++i) {
                if (board[rowPicked - i][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked - i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked - i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked && i <= columnPicked; ++i) {
                if (board[rowPicked + i][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked - i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked - i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked && i <= 7 - columnPicked; ++i) {
                if (board[rowPicked - i][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked + i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked + i] <= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked && i <= 7 - columnPicked; ++i) {
                if (board[rowPicked + i][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked + i] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked + i] <= 0) continue;
                i = 100;
            }
        } else if (piece == -6 && !this.whiteTurn) {
            int i;
            for (i = 1; i <= columnPicked; ++i) {
                if (board[rowPicked][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked][columnPicked - i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked][columnPicked - i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - columnPicked; ++i) {
                if (board[rowPicked][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked][columnPicked + i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked][columnPicked + i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked; ++i) {
                if (board[rowPicked - i][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked; ++i) {
                if (board[rowPicked + i][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked && i <= columnPicked; ++i) {
                if (board[rowPicked - i][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked - i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked - i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked && i <= columnPicked; ++i) {
                if (board[rowPicked + i][columnPicked - i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked - i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked - i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked - i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= rowPicked && i <= 7 - columnPicked; ++i) {
                if (board[rowPicked - i][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked - i][columnPicked + i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked - i][columnPicked + i] >= 0) continue;
                i = 100;
            }
            for (i = 1; i <= 7 - rowPicked && i <= 7 - columnPicked; ++i) {
                if (board[rowPicked + i][columnPicked + i] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    continue;
                }
                if (board[rowPicked + i][columnPicked + i] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + i;
                    this.optionsY[this.optionsFilled] = columnPicked + i;
                    ++this.optionsFilled;
                    i = 100;
                    continue;
                }
                if (board[rowPicked + i][columnPicked + i] >= 0) continue;
                i = 100;
            }
        } else if (piece == 7 && this.whiteTurn) {
            if (columnPicked > 0) {
                if (board[rowPicked][columnPicked - 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked][columnPicked - 1] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
            }
            if (columnPicked < 7) {
                if (board[rowPicked][columnPicked + 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked][columnPicked + 1] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked > 0) {
                if (board[rowPicked - 1][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                } else if (board[rowPicked - 1][columnPicked] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked < 7) {
                if (board[rowPicked + 1][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                } else if (board[rowPicked + 1][columnPicked] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked > 0 && columnPicked > 0) {
                if (board[rowPicked - 1][columnPicked - 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked - 1][columnPicked - 1] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked < 7 && columnPicked > 0) {
                if (board[rowPicked + 1][columnPicked - 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked + 1][columnPicked - 1] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked > 0 && columnPicked < 7) {
                if (board[rowPicked - 1][columnPicked + 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked - 1][columnPicked + 1] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked < 7 && columnPicked < 7) {
                if (board[rowPicked + 1][columnPicked + 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked + 1][columnPicked + 1] < 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked == 4 && columnPicked == 7 && !this.kingMoveWhite) {
                if (board[rowPicked + 1][columnPicked] == 0 && board[rowPicked + 2][columnPicked] == 0 && board[rowPicked + 3][columnPicked] == 3 && !this.rookTwoMoveWhite && PKID.squareSafe(rowPicked, columnPicked, this.whiteTurn, false) && PKID.squareSafe(rowPicked + 1, columnPicked, this.whiteTurn, false) && PKID.squareSafe(rowPicked + 2, columnPicked, this.whiteTurn, false)) {
                    this.optionsX[this.optionsFilled] = rowPicked + 2;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                }
                if (board[rowPicked - 1][columnPicked] == 0 && board[rowPicked - 2][columnPicked] == 0 && board[rowPicked - 4][columnPicked] == 2 && !this.rookOneMoveWhite && board[rowPicked - 3][columnPicked] == 0 && PKID.squareSafe(rowPicked, columnPicked, this.whiteTurn, false) && PKID.squareSafe(rowPicked - 1, columnPicked, this.whiteTurn, false) && PKID.squareSafe(rowPicked - 2, columnPicked, this.whiteTurn, false)) {
                    this.optionsX[this.optionsFilled] = rowPicked - 2;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                }
            }
        } else if (piece == -7 && !this.whiteTurn) {
            if (columnPicked > 0) {
                if (board[rowPicked][columnPicked - 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked][columnPicked - 1] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
            }
            if (columnPicked < 7) {
                if (board[rowPicked][columnPicked + 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked][columnPicked + 1] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked > 0) {
                if (board[rowPicked - 1][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                } else if (board[rowPicked - 1][columnPicked] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked < 7) {
                if (board[rowPicked + 1][columnPicked] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                } else if (board[rowPicked + 1][columnPicked] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked > 0 && columnPicked > 0) {
                if (board[rowPicked - 1][columnPicked - 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked - 1][columnPicked - 1] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked < 7 && columnPicked > 0) {
                if (board[rowPicked + 1][columnPicked - 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked + 1][columnPicked - 1] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked - 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked > 0 && columnPicked < 7) {
                if (board[rowPicked - 1][columnPicked + 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked - 1][columnPicked + 1] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked - 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked < 7 && columnPicked < 7) {
                if (board[rowPicked + 1][columnPicked + 1] == 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                } else if (board[rowPicked + 1][columnPicked + 1] > 0) {
                    this.optionsX[this.optionsFilled] = rowPicked + 1;
                    this.optionsY[this.optionsFilled] = columnPicked + 1;
                    ++this.optionsFilled;
                }
            }
            if (rowPicked == 4 && columnPicked == 0 && !this.kingMoveBlack) {
                if (board[rowPicked + 1][columnPicked] == 0 && board[rowPicked + 2][columnPicked] == 0 && board[rowPicked + 3][columnPicked] == -3 && !this.rookTwoMoveBlack && PKID.squareSafe(rowPicked, columnPicked, this.whiteTurn, false) && PKID.squareSafe(rowPicked + 1, columnPicked, this.whiteTurn, false) && PKID.squareSafe(rowPicked + 2, columnPicked, this.whiteTurn, false)) {
                    this.optionsX[this.optionsFilled] = rowPicked + 2;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                }
                if (board[rowPicked - 1][columnPicked] == 0 && board[rowPicked - 2][columnPicked] == 0 && board[rowPicked - 4][columnPicked] == -2 && !this.rookOneMoveBlack && board[rowPicked - 3][columnPicked] == 0 && PKID.squareSafe(rowPicked, columnPicked, this.whiteTurn, false) && PKID.squareSafe(rowPicked - 1, columnPicked, this.whiteTurn, false) && PKID.squareSafe(rowPicked - 2, columnPicked, this.whiteTurn, false)) {
                    this.optionsX[this.optionsFilled] = rowPicked - 2;
                    this.optionsY[this.optionsFilled] = columnPicked;
                    ++this.optionsFilled;
                }
            }
        }
    }

    public void drawCurrentPosition() {
        this.drawBoard();
        this.imageMode(3);
        for (int i = 0; i <= 7; ++i) {
            for (int j = 0; j <= 7; ++j) {
                if (board[i][j] == 1) {
                    this.image(this.whitePawn, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == 2 || board[i][j] == 3 || board[i][j] == 8) {
                    this.image(this.whiteRook, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == 4) {
                    this.image(this.whiteBishop, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == 5) {
                    this.image(this.whiteKnight, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == 6) {
                    this.image(this.whiteQueen, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == 7) {
                    this.image(this.whiteKing, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == -1) {
                    this.image(this.blackPawn, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == -2 || board[i][j] == -3 || board[i][j] == -8) {
                    this.image(this.blackRook, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == -4) {
                    this.image(this.blackBishop, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == -5) {
                    this.image(this.blackKnight, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] == -6) {
                    this.image(this.blackQueen, i * 100 + 50, j * 100 + 50);
                    continue;
                }
                if (board[i][j] != -7) continue;
                this.image(this.blackKing, i * 100 + 50, j * 100 + 50);
            }
        }
    }

    public void showMovementOptions() {
        for (int i = 0; i <= 20; ++i) {
            if (this.optionsX[i] == -1000) continue;
            this.fill(0.0f, 255.0f, 255.0f);
            this.ellipse(this.optionsX[i] * 100 + 50, this.optionsY[i] * 100 + 50, 20.0f, 20.0f);
        }
    }

    public void showKingDanger() {
        if (this.kingDanger || this.inCheck) {
            this.strokeWeight(10.0f);
            this.stroke(255.0f, 0.0f, 0.0f);
            this.noFill();
            this.square(this.findKingX(this.whiteTurn) * 100 + 5, this.findKingY(this.whiteTurn) * 100 + 5, 90.0f);
            this.strokeWeight(0.0f);
            this.stroke(0);
        }
    }

    public void showPromote() {
        if (this.whitePromote) {
            this.strokeWeight(2.0f);
            this.fill(255.0f, 255.0f, 255.0f);
            this.rect(190.0f, 90.0f, 420.0f, 120.0f);
            this.strokeWeight(0.0f);
            this.imageMode(3);
            this.image(this.whiteQueen, 250.0f, 150.0f);
            this.image(this.whiteRook, 350.0f, 150.0f);
            this.image(this.whiteBishop, 450.0f, 150.0f);
            this.image(this.whiteKnight, 550.0f, 150.0f);
        } else if (this.blackPromote) {
            this.strokeWeight(2.0f);
            this.fill(255.0f, 255.0f, 255.0f);
            this.rect(190.0f, 590.0f, 420.0f, 120.0f);
            this.strokeWeight(0.0f);
            this.imageMode(3);
            this.image(this.blackQueen, 250.0f, 650.0f);
            this.image(this.blackRook, 350.0f, 650.0f);
            this.image(this.blackBishop, 450.0f, 650.0f);
            this.image(this.blackKnight, 550.0f, 650.0f);
        }
    }

    public void promote(int x, int y) {
        if (x > 225 && x < 275 && y > 125 && y < 175) {
            Main.board[this.newRowPicked][this.newColumnPicked] = 6;
            this.whitePromote = false;
            this.checkEnding();
        } else if (x > 325 && x < 375 && y > 125 && y < 175) {
            Main.board[this.newRowPicked][this.newColumnPicked] = 8;
            this.whitePromote = false;
            this.checkEnding();
        } else if (x > 425 && x < 475 && y > 125 && y < 175) {
            Main.board[this.newRowPicked][this.newColumnPicked] = 4;
            this.whitePromote = false;
            this.checkEnding();
        } else if (x > 525 && x < 575 && y > 125 && y < 175) {
            Main.board[this.newRowPicked][this.newColumnPicked] = 5;
            this.whitePromote = false;
            this.checkEnding();
        } else if (x > 225 && x < 275 && y > 625 && y < 675) {
            Main.board[this.newRowPicked][this.newColumnPicked] = -6;
            this.blackPromote = false;
            this.checkEnding();
        } else if (x > 325 && x < 375 && y > 625 && y < 675) {
            Main.board[this.newRowPicked][this.newColumnPicked] = -8;
            this.blackPromote = false;
            this.checkEnding();
        } else if (x > 425 && x < 475 && y > 625 && y < 675) {
            Main.board[this.newRowPicked][this.newColumnPicked] = -4;
            this.blackPromote = false;
            this.checkEnding();
        } else if (x > 525 && x < 575 && y > 625 && y < 675) {
            Main.board[this.newRowPicked][this.newColumnPicked] = -5;
            this.blackPromote = false;
            this.checkEnding();
        }
    }

    public void movePiece(int rowPicked, int columnPicked, int newRowPicked, int newColumnPicked) {
        PutKingInDanger PKID = new PutKingInDanger();
        CheckCheckmate CC = new CheckCheckmate();
        this.mateType = 0;
        this.repetitionType = 0;
        this.captureWasMade = false;
        this.pieceThatIsMoving = board[rowPicked][columnPicked];
        this.originalPiece = board[newRowPicked][newColumnPicked];
        if (board[newRowPicked][newColumnPicked] != 0 || this.thisWasEnPassant) {
            this.captureWasMade = true;
        }
        if (this.pieceThatIsMoving == 7 && rowPicked == 4 && columnPicked == 7 && newRowPicked == 6 && newColumnPicked == 7) {
            Main.board[newRowPicked][newColumnPicked] = this.pieceThatIsMoving;
            Main.board[rowPicked][columnPicked] = 0;
            Main.board[5][7] = 3;
            Main.board[7][7] = 0;
        } else if (this.pieceThatIsMoving == 7 && rowPicked == 4 && columnPicked == 7 && newRowPicked == 2 && newColumnPicked == 7) {
            Main.board[newRowPicked][newColumnPicked] = this.pieceThatIsMoving;
            Main.board[rowPicked][columnPicked] = 0;
            Main.board[3][7] = 2;
            Main.board[0][7] = 0;
        } else if (this.pieceThatIsMoving == -7 && rowPicked == 4 && columnPicked == 0 && newRowPicked == 6 && newColumnPicked == 0) {
            Main.board[newRowPicked][newColumnPicked] = this.pieceThatIsMoving;
            Main.board[rowPicked][columnPicked] = 0;
            Main.board[5][0] = -3;
            Main.board[7][0] = 0;
        } else if (this.pieceThatIsMoving == -7 && rowPicked == 4 && columnPicked == 0 && newRowPicked == 2 && newColumnPicked == 0) {
            Main.board[newRowPicked][newColumnPicked] = this.pieceThatIsMoving;
            Main.board[rowPicked][columnPicked] = 0;
            Main.board[3][0] = -2;
            Main.board[0][0] = 0;
        } else {
            Main.board[newRowPicked][newColumnPicked] = this.pieceThatIsMoving;
            Main.board[rowPicked][columnPicked] = 0;
        }
        boolean bl = allowEnPassant = this.pieceThatIsMoving == 1 && newRowPicked == rowPicked && columnPicked - newColumnPicked == 2 || this.pieceThatIsMoving == -1 && newRowPicked == rowPicked && newColumnPicked - columnPicked == 2;
        if (newRowPicked < 7) {
            boolean bl2 = enPassantLeft = allowEnPassant && (board[newRowPicked + 1][newColumnPicked] == 1 || board[newRowPicked + 1][newColumnPicked] == -1);
        }
        if (newRowPicked > 0) {
            boolean bl3 = enPassantRight = allowEnPassant && (board[newRowPicked - 1][newColumnPicked] == 1 || board[newRowPicked - 1][newColumnPicked] == -1);
        }
        if (this.pieceThatIsMoving == 1 && this.thisWasEnPassant) {
            Main.board[newRowPicked][newColumnPicked + 1] = 0;
        } else if (this.pieceThatIsMoving == -1 && this.thisWasEnPassant) {
            Main.board[newRowPicked][newColumnPicked - 1] = 0;
        }
        if (!PKID.squareSafe(this.findKingX(this.whiteTurn), this.findKingY(this.whiteTurn), this.whiteTurn, false)) {
            Main.board[rowPicked][columnPicked] = this.pieceThatIsMoving;
            Main.board[newRowPicked][newColumnPicked] = this.originalPiece;
            if (this.whiteTurn && this.thisWasEnPassant) {
                Main.board[newRowPicked][newColumnPicked + 1] = -1;
                allowEnPassant = true;
            } else if (!this.whiteTurn && this.thisWasEnPassant) {
                Main.board[newRowPicked][newColumnPicked - 1] = 1;
                allowEnPassant = true;
            }
            this.captureWasMade = false;
            this.kingDanger = true;
        } else {
            this.clearOptions();
            this.whiteTurn = !this.whiteTurn;
            this.thisWasEnPassant = false;
            this.kingDanger = false;
            if (this.pieceThatIsMoving == 2) {
                this.rookOneMoveWhite = true;
            } else if (this.pieceThatIsMoving == 3) {
                this.rookTwoMoveWhite = true;
            } else if (this.pieceThatIsMoving == -2) {
                this.rookOneMoveBlack = true;
            } else if (this.pieceThatIsMoving == -3) {
                this.rookTwoMoveBlack = true;
            } else if (this.pieceThatIsMoving == 7) {
                this.kingMoveWhite = true;
            } else if (this.pieceThatIsMoving == -7) {
                this.kingMoveBlack = true;
            }
            this.whitePromote = this.pieceThatIsMoving == 1 && columnPicked == 1 && newColumnPicked == 0;
            boolean bl4 = this.blackPromote = this.pieceThatIsMoving == -1 && columnPicked == 6 && newColumnPicked == 7;
            if (PKID.squareSafe(this.findKingX(this.whiteTurn), this.findKingY(this.whiteTurn), this.whiteTurn, false)) {
                this.inCheck = false;
            } else if (!PKID.squareSafe(this.findKingX(this.whiteTurn), this.findKingY(this.whiteTurn), this.whiteTurn, false)) {
                this.inCheck = true;
            }
            this.mateType = CC.checkCheckmate(this.findKingX(this.whiteTurn), this.findKingY(this.whiteTurn), this.whiteTurn);
            this.repetitionType = this.SSB.checkRepetition(this.pieceThatIsMoving, this.captureWasMade);
            if (this.mateType == 1) {
                currentState = this.whiteTurn ? GameState.BLACKWIN : GameState.WHITEWIN;
                howEnd = PossibleEndings.CHECKMATE;
                this.drawCurrentPosition();
                this.showKingDanger();
            } else if (this.mateType == 2) {
                currentState = GameState.DRAW;
                howEnd = PossibleEndings.STALEMATE;
                this.drawCurrentPosition();
            } else if (this.checkInsufficient()) {
                currentState = GameState.DRAW;
                howEnd = PossibleEndings.INSUFFICIENT;
                this.drawCurrentPosition();
            } else if (this.repetitionType == 1) {
                currentState = GameState.DRAW;
                howEnd = PossibleEndings.THREEMOVEREPETITION;
                this.drawCurrentPosition();
            } else if (this.repetitionType == 2) {
                currentState = GameState.DRAW;
                howEnd = PossibleEndings.FIFTYMOVERULE;
                this.drawCurrentPosition();
            }
        }
    }

    public void checkEnding() {
        CheckCheckmate CC = new CheckCheckmate();
        this.mateType = CC.checkCheckmate(this.findKingX(this.whiteTurn), this.findKingY(this.whiteTurn), this.whiteTurn);
        if (this.mateType == 1) {
            currentState = this.whiteTurn ? GameState.BLACKWIN : GameState.WHITEWIN;
            howEnd = PossibleEndings.CHECKMATE;
            this.drawCurrentPosition();
            this.showKingDanger();
        } else if (this.mateType == 2) {
            currentState = GameState.DRAW;
            howEnd = PossibleEndings.STALEMATE;
            this.drawCurrentPosition();
        } else if (this.checkInsufficient()) {
            currentState = GameState.DRAW;
            howEnd = PossibleEndings.INSUFFICIENT;
            this.drawCurrentPosition();
        }
    }

    public boolean checkInsufficient() {
        this.isInsufficient = false;
        this.pieceValuesWhite = 0;
        this.pieceValuesBlack = 0;
        for (int i = 0; i <= 7; ++i) {
            for (int j = 0; j <= 7; ++j) {
                if (board[i][j] == 1 || board[i][j] == -1 || board[i][j] == 2 || board[i][j] == -2 || board[i][j] == 3 || board[i][j] == -3 || board[i][j] == 6 || board[i][j] == -6) {
                    return false;
                }
                if (board[i][j] == 4) {
                    this.pieceValuesWhite += 3;
                    continue;
                }
                if (board[i][j] == -4) {
                    this.pieceValuesBlack += 3;
                    continue;
                }
                if (board[i][j] == 5) {
                    this.pieceValuesWhite += 2;
                    continue;
                }
                if (board[i][j] != -5) continue;
                this.pieceValuesBlack += 2;
            }
        }
        if (this.pieceValuesWhite < 5 && this.pieceValuesBlack < 5) {
            this.isInsufficient = true;
        }
        return this.isInsufficient;
    }

    public void clearOptions() {
        for (int i = 0; i <= 90; ++i) {
            this.optionsX[i] = -1000;
            this.optionsY[i] = -1000;
        }
        this.optionsFilled = 0;
    }

    public int findKingX(boolean white) {
        this.kingX = -1000;
        for (int i = 0; i <= 7; ++i) {
            for (int j = 0; j <= 7; ++j) {
                if (board[i][j] == 7 && white) {
                    this.kingX = i;
                    continue;
                }
                if (board[i][j] != -7 || white) continue;
                this.kingX = i;
            }
        }
        return this.kingX;
    }

    public int findKingY(boolean white) {
        this.kingY = -1000;
        for (int i = 0; i <= 7; ++i) {
            for (int j = 0; j <= 7; ++j) {
                if (board[i][j] == 7 && white) {
                    this.kingY = j;
                    continue;
                }
                if (board[i][j] != -7 || white) continue;
                this.kingY = j;
            }
        }
        return this.kingY;
    }

    static enum GameState {
        RUNNING,
        WHITEWIN,
        BLACKWIN,
        DRAW;

    }

    static enum PossibleEndings {
        CHECKMATE,
        STALEMATE,
        INSUFFICIENT,
        THREEMOVEREPETITION,
        FIFTYMOVERULE;

    }
}

